-- select * from snb_b2b.niksm_finance_tlog_metrics;

select source, date_trunc('month',utc_transaction_dttm)::date,
       count()
from snb_b2b.niksm_temp_1002_tlog_detailed
group by 1,2 order by 1,2;

-- Проверка что не появилось новых source-detailed_product
-- subsidy_discount_payback
-- coupon_plus
select tlog.source,
       tlog.detailed_product,
       sum(transaction_value) as transaction_value,
       min(utc_transaction_dttm)
from snb_b2b.niksm_temp_1002_tlog_detailed as tlog
  left join snb_b2b.niksm_finance_tlog_metrics as metr
    on metr.source = tlog.source
    and metr.detailed_product = tlog.detailed_product
    and (gross_commission_revenue <> 0 or incentives <> 0 or b2b_revenue<>0 or b2b_expenses <> 0)
where metr.source is null
group by 1,2 order by 3 desc;

-- Проверка что на order_id есть только 1 сервис - Такси или Доставки
with serv(service_id,service_owner) as (
    values (1161, 'Доставка'),
           (1162, 'Доставка'),
           (1163, 'Доставка'),
           (1164, 'Доставка'),
           (719, 'Доставка'),
           (718, 'Доставка'),
           (1168, 'Доставка'),
           (111, 'Такси'),
           (124, 'Такси'),
           (125, 'Такси'),
           (128, 'Такси'),
           (137, 'Такси'),
           (651, 'Такси'),
           (650, 'Такси'),
           (697, 'Такси')
)
-- 1 check other services
-- select count()
-- from snb_b2b.niksm_temp_1002_tlog_detailed as tlog
--   left join serv
--     on serv.service_id = tlog.service_id
-- where serv.service_id is null;
-- endof 1
, t as (
    select order_id,
           service_owner,
           sum(transaction_value * gross_commission_revenue) as gross_commission_revenue,
           sum(transaction_value * incentives) as incentives,
           sum(transaction_value * b2b_revenue) as b2b_revenue,
           sum(transaction_value * b2b_expenses) as b2b_expenses,
           count() over (partition by order_id) as cnt
    from snb_b2b.niksm_temp_1002_tlog_detailed as tlog
      join snb_b2b.niksm_finance_tlog_metrics as metr
        on metr.source = tlog.source
        and metr.detailed_product = tlog.detailed_product
        and (gross_commission_revenue <> 0 or incentives <> 0 or b2b_revenue<>0 or b2b_expenses <> 0)
      left join serv
        on serv.service_id = tlog.service_id
    where tlog.utc_transaction_dttm >= '2022-01-01'
      and tlog.utc_transaction_dttm <  '2022-05-01'
    group by order_id,
           service_owner
)
-- select * from t where cnt = 2 order by order_id, service_owner limit 50;
select cnt,
       service_owner,
       sum(gross_commission_revenue) as gross_commission_revenue,
       sum(incentives) as incentives,
       sum(b2b_expenses) as b2b_expenses,
       count() as orders_cnt
from t
group by 1,2
;

select * from snb_b2b.niksm_temp_1002_tlog_detailed as tlog
where order_id = '00001b89d498d9438548a594017e37c9';

select service_id,
       source,
       detailed_product,
       sum(transaction_value) as transaction_value
from snb_b2b.niksm_temp_1002_tlog_detailed as tlog
--   join snb_b2b.niksm_finance_tlog_metrics as metr
--     on metr.source = tlog.source
--     and metr.detailed_product = tlog.detailed_product
--     and (gross_commission_revenue <> 0 or incentives <> 0 or b2b_revenue<>0 or b2b_expenses <> 0)
where utc_transaction_dttm >= timestamp'2022-01-01' at time zone 'Europe/Moscow' at time zone 'UTC'
  and utc_transaction_dttm <  timestamp'2022-05-01' at time zone 'Europe/Moscow' at time zone 'UTC'
  and currency_code = 'ILS'
group by 1,2,3;

select service_id,
       detailed_product,
       floor(sum(case when transaction_type = 'payment' then transaction_value else -transaction_value end)) as transaction_value
from core_ods_billing.expenses
where utc_transaction_dttm >= timestamp'2022-01-01'
  and currency_code = 'ILS'
group by 1,2 order by 1,3 desc;

------------------------------------------------------------------------------------------------------------------------

-- drop table if exists snb_delivery.niksm_temp_1002_tlog;
-- create table snb_delivery.niksm_temp_1002_tlog as
truncate table snb_delivery.niksm_temp_1002_tlog;
insert into snb_delivery.niksm_temp_1002_tlog (order_id, currency_code, service_owner, utc_transaction_dttm, gross_commission_revenue, incentives, b2b_revenue, b2b_expenses, taxi_client_service_flg)
with serv(service_id,service_owner) as (
    values (1161, 'Delivery'),
           (1162, 'Delivery'),
           (1163, 'Delivery'),
           (1164, 'Delivery'),
           (719, 'Delivery'),
           (718, 'Delivery'),
           (1168, 'Delivery'),
           (111, 'Taxi'),
           (124, 'Taxi'),
           (125, 'Taxi'),
           (128, 'Taxi'),
           (137, 'Taxi'),
           (651, 'Taxi'),
           (650, 'Taxi'),
           (697, 'Taxi')
)
select order_id,
       currency_code,
       service_owner,
       utc_transaction_dttm,
       sum(transaction_value * gross_commission_revenue) as gross_commission_revenue,
       sum(transaction_value * incentives) as incentives,
       sum(transaction_value * b2b_revenue) as b2b_revenue,
       sum(transaction_value * b2b_expenses) as b2b_expenses,
       bool_or(sum(transaction_value * b2b_revenue)<>0 and service_owner = 'Taxi') over (partition by order_id) as taxi_client_service_flg
from snb_delivery.niksm_temp_1002_tlog_detailed as tlog
  join snb_b2b.niksm_finance_tlog_metrics as metr
    on metr.source = tlog.source
    and metr.detailed_product = tlog.detailed_product
--     and (gross_commission_revenue <> 0 or incentives <> 0 or b2b_revenue<>0 or b2b_expenses <> 0)
  left join serv
    on serv.service_id = tlog.service_id
-- where tlog.utc_transaction_dttm >= '2022-01-01'
--   and tlog.utc_transaction_dttm <  '2022-02-01'
group by order_id,
         currency_code,
         service_owner,
         utc_transaction_dttm
-- distributed by (order_id);
--
analyse snb_delivery.niksm_temp_1002_tlog;
-- select count() from snb_delivery.niksm_temp_1002_tlog;

-- slot [geohash - 10 min] with high econom surge
-- drop table if exists snb_delivery.niksm_temp_1002_taxi_high_surge;
-- create table snb_delivery.niksm_temp_1002_taxi_high_surge as
truncate table snb_delivery.niksm_temp_1002_taxi_high_surge;
insert into snb_delivery.niksm_temp_1002_taxi_high_surge (source_geohash, time_slot, taxi_high_surge_flg)
select substr(source_geohash,1,5) as source_geohash,
       date_trunc('hour',utc_order_created_dttm)
       + make_interval(0, 0, 0, 0, 0,
           (floor(extract(minute from utc_order_created_dttm)/10.)*10) :: int) as time_slot,
       true as taxi_high_surge_flg
from taxi_cdm_marketplace.fct_order
where true
  and utc_order_created_dttm >= '2021-11-01'
  and tariff_class_code = 'econom'
  and success_order_flg
group by 1,2
having sum(order_cost) > sum(order_before_surge_cost)*1.5
-- distributed by (source_geohash, time_slot)
;
analyse snb_delivery.niksm_temp_1002_taxi_high_surge;

-- drop table if exists snb_delivery.niksm_temp_1002_fct;
-- create table snb_delivery.niksm_temp_1002_fct as
truncate table snb_delivery.niksm_temp_1002_fct;
insert into snb_delivery.niksm_temp_1002_fct
    (order_id, utc_order_created_dttm, executor_profile_sk, country_name_ru,
     corp_order_flg, delivery_crm_flg, source_geohash, time_slot, deliveries_cnt,
     gmv_rub, gross_commission_revenue_rub)
select order_id,
       utc_order_created_dttm,
       executor_profile_sk,
       country_name_ru,
       corp_order_flg,
       crm_main.contract_id is not null or crm_isr.contract_id is not null as delivery_crm_flg,
       --
       substr(source_geohash,1,5) as source_geohash,
       date_trunc('hour',utc_order_created_dttm)
       + make_interval(0, 0, 0, 0, 0,
           (floor(extract(minute from utc_order_created_dttm)/10.)*10) :: int) as time_slot,
       -- success_order_flg !!!
       delivery_point_cnt as deliveries_cnt,
       gmv_amt * coalesce(currency_rate,1.) as gmv_rub,
       gross_commission_revenue_amt * coalesce(currency_rate,1.) as gross_commission_revenue_rub
from taxi_cdm_marketplace.fct_order_metric fct
  join snb_delivery.logdata_delivery_tariff
    on tariff_class_code = order_tariff
  left join snb_b2b.niksm_b2b_contracts_info crm_main
    on crm_main.contract_id = fct.corp_contract_id
    and crm_main.which_crm in (6,8)
  left join snb_b2b.niksm_b2b_contracts_info_sf crm_isr
    on crm_isr.contract_id = fct.corp_contract_id
where utc_order_created_dttm >= '2021-11-01'
--   and success_order_flg
-- distributed by (order_id, executor_profile_sk)
;
analyse snb_delivery.niksm_temp_1002_fct;

-- drop table if exists snb_delivery.niksm_temp_1002_fct_supply_state_hist;
-- create table snb_delivery.niksm_temp_1002_fct_supply_state_hist as
truncate table snb_delivery.niksm_temp_1002_fct_supply_state_hist;
insert into snb_delivery.niksm_temp_1002_fct_supply_state_hist (order_id, executor_profile_sk, driver_has_taxi_tariff_flg)
select order_id,
       executor_profile_sk,
       array_length(
               array_remove(
                   array_remove(
                       array_remove(
                           array_remove(
                               array_remove(
                                   lcl_available_tariff_class_code_list,
                                   'courier'),
                               'express'),
                           'cargo'),
                       'cargocorp'),
                   'ubernight')
               , 1) > 0 as driver_has_taxi_tariff_flg
from (
    select sppl.order_id,
           sppl.executor_profile_sk,
           lcl_available_tariff_class_code_list,
           row_number() over (partition by sppl.order_id, sppl.executor_profile_sk order by utc_valid_from_dttm nulls last) as rn
    from taxi_cdm_supply.fct_supply_state_hist sppl
      join snb_delivery.niksm_temp_1002_fct fct
        on sppl.order_id = fct.order_id
        and sppl.executor_profile_sk = fct.executor_profile_sk
    where utc_valid_from_dttm >= '2021-11-01'
) q
where rn = 1
-- distributed by (order_id, executor_profile_sk)
;
analyse snb_delivery.niksm_temp_1002_fct_supply_state_hist;

-- order attributes
-- drop table if exists snb_delivery.niksm_temp_1002_order_attr;
-- create table snb_delivery.niksm_temp_1002_order_attr as
truncate table snb_delivery.niksm_temp_1002_order_attr;
insert into snb_delivery.niksm_temp_1002_order_attr
    (order_id, country_name_ru, corp_order_flg, delivery_crm_flg, driver_has_taxi_tariff_flg, taxi_high_surge_flg)
select fct.order_id,
       country_name_ru,
       corp_order_flg,
       delivery_crm_flg,
       coalesce(driver_has_taxi_tariff_flg, False) as driver_has_taxi_tariff_flg,
       coalesce(taxi_high_surge_flg, False) as taxi_high_surge_flg
from snb_delivery.niksm_temp_1002_fct fct
  left join snb_delivery.niksm_temp_1002_fct_supply_state_hist sppl
    on sppl.order_id = fct.order_id
    and sppl.executor_profile_sk = fct.executor_profile_sk
  left join snb_delivery.niksm_temp_1002_taxi_high_surge taxi_high_surge
    on taxi_high_surge.source_geohash = fct.source_geohash
    and taxi_high_surge.time_slot = fct.time_slot
-- distributed by (order_id)
;
analyse snb_delivery.niksm_temp_1002_order_attr;

-- drop table if exists snb_delivery.niksm_fin_delivery_taxi_divorce_comm;
-- create table snb_delivery.niksm_fin_delivery_taxi_divorce_comm as
truncate table snb_delivery.niksm_fin_delivery_taxi_divorce_comm;
insert into snb_delivery.niksm_fin_delivery_taxi_divorce_comm
    (currency_code, service_owner, taxi_client_service_flg, country_name_ru, corp_order_flg, delivery_crm_flg,
     driver_has_taxi_tariff_flg, taxi_high_surge_flg, gross_commission_revenue, incentives, b2b_revenue, b2b_expenses)
with tlog as (
    select order_id,
           currency_code,
           service_owner,
           gross_commission_revenue,
           incentives,
           b2b_revenue,
           b2b_expenses,
           taxi_client_service_flg
    from snb_delivery.niksm_temp_1002_tlog
    where utc_transaction_dttm >= '2022-01-01'
      and utc_transaction_dttm <  '2022-02-01'
)
select currency_code,
       service_owner,
       taxi_client_service_flg,
       order_attr.country_name_ru,
       order_attr.corp_order_flg,
       coalesce(order_attr.delivery_crm_flg, False) as delivery_crm_flg,
       coalesce(order_attr.driver_has_taxi_tariff_flg, False) as driver_has_taxi_tariff_flg,
       coalesce(order_attr.taxi_high_surge_flg, False) as taxi_high_surge_flg,
       --
       sum(gross_commission_revenue) as gross_commission_revenue,
       sum(incentives) as incentives,
       sum(b2b_revenue) as b2b_revenue,
       sum(b2b_expenses) as b2b_expenses
from tlog
  left join snb_delivery.niksm_temp_1002_order_attr order_attr
    on order_attr.order_id = tlog.order_id
group by 1,2,3,4,5,6,7,8;
--
-- revoke select on snb_delivery.niksm_fin_delivery_taxi_divorce_comm from ro_snb_delivery;
-- grant select on snb_delivery.niksm_fin_delivery_taxi_divorce_comm to niksm;
analyse snb_delivery.niksm_fin_delivery_taxi_divorce_comm;


select *
from snb_delivery.niksm_fin_delivery_taxi_divorce_comm;



--====================================================================================================================--




with tlog as (
    select order_id,
           currency_code,
           service_owner,
           gross_commission_revenue,
           incentives,
           b2b_revenue,
           b2b_expenses,
           taxi_client_service_flg
    from snb_delivery.niksm_temp_1002_tlog
    where utc_transaction_dttm >= '2022-01-01'
      and utc_transaction_dttm <  '2022-02-01'
)
select tlog.*
--        tlog.order_id is not null,
--        substr(tlog.order_id,1,8) = 'noorder/',
--        --
--        sum(gross_commission_revenue) as gross_commission_revenue,
--        sum(incentives) as incentives,
--        sum(b2b_revenue) as b2b_revenue,
--        sum(b2b_expenses) as b2b_expenses
from tlog
  left join snb_delivery.niksm_temp_1002_order_attr order_attr
    on order_attr.order_id = tlog.order_id
where order_attr.order_id is null
  and currency_code = 'RUB'
  and substr(tlog.order_id,1,8) <> 'noorder/'
-- group by 1,2;
order by gross_commission_revenue desc
limit 50;

select *
from taxi_cdm_marketplace.fct_order
where utc_order_created_dttm >= '2021-10-01'
  and order_id = 'd5eac1ec70861c33b6507ed73411bf75';

--Батчинг?
with t as (
    select order_id,
           bool_or(service_owner = 'Taxi' and b2b_revenue <> 0) as taxi_revenue,
           bool_or(service_owner = 'Delivery' and b2b_revenue <> 0) as delivery_revenue,
           bool_or(service_owner = 'Taxi' and b2b_expenses <> 0) as taxi_expenses,
           bool_or(service_owner = 'Delivery' and b2b_expenses <> 0) as delivery_expenses
    from snb_delivery.niksm_temp_1002_tlog
    where utc_transaction_dttm >= '2022-01-01'
      and utc_transaction_dttm <  '2022-02-01'
      and taxi_client_service_flg
    group by order_id
)
select taxi_revenue, delivery_revenue, taxi_expenses, delivery_expenses,
       count()
from t
group by 1,2,3,4
order by 1,2,3,4
;


with serv(service_id,service_owner) as (
    values (1161, 'Delivery'),
           (1162, 'Delivery'),
           (1163, 'Delivery'),
           (1164, 'Delivery'),
           (719, 'Delivery'),
           (718, 'Delivery'),
           (1168, 'Delivery'),
           (111, 'Taxi'),
           (124, 'Taxi'),
           (125, 'Taxi'),
           (128, 'Taxi'),
           (137, 'Taxi'),
           (651, 'Taxi'),
           (650, 'Taxi'),
           (697, 'Taxi')
)
, niksm_temp_1002_tlog as (
    select order_id,
           currency_code,
           service_owner,
           tariff_class,
           utc_transaction_dttm,
           sum(transaction_value * gross_commission_revenue) as gross_commission_revenue,
           sum(transaction_value * incentives) as incentives,
           sum(transaction_value * b2b_revenue) as b2b_revenue,
           sum(transaction_value * b2b_expenses) as b2b_expenses,
           bool_or(sum(transaction_value * b2b_revenue)<>0 and service_owner = 'Taxi')
               over (partition by order_id) as taxi_client_service_flg  -- в т.ч. записи по order_id могут быть на другую дату транзакции
    from snb_b2b.niksm_temp_1002_tlog_detailed as tlog
      join snb_b2b.niksm_finance_tlog_metrics as metr
        on metr.source = tlog.source
        and metr.detailed_product = tlog.detailed_product
      left join serv
        on serv.service_id = tlog.service_id
    group by order_id,
             currency_code,
             service_owner,
             tariff_class,
             utc_transaction_dttm
)
, tlog as (
    select order_id,
           utc_transaction_dttm at time zone 'UTC' at time zone 'Europe/Moscow' as msk_transaction_dttm,
           currency_code,
           service_owner,
           tariff_class,
           gross_commission_revenue,
           incentives,
           b2b_revenue,
           b2b_expenses,
           taxi_client_service_flg
    from niksm_temp_1002_tlog
    where utc_transaction_dttm >= timestamp'2022-01-01' at time zone 'Europe/Moscow' at time zone 'UTC'
      and utc_transaction_dttm <  timestamp'2022-03-01' at time zone 'Europe/Moscow' at time zone 'UTC'
)
select date_trunc('month',msk_transaction_dttm)::date as msk_transaction_month,
       msk_transaction_dttm::date as msk_transaction_dt,
       currency_code,
       service_owner,
       tariff_class,
       taxi_client_service_flg,
       order_attr.country_name_ru,
       order_attr.corp_order_flg,
       coalesce(order_attr.delivery_crm_flg, False) as delivery_crm_flg,
       coalesce(order_attr.driver_has_taxi_tariff_flg, False) as driver_has_taxi_tariff_flg,
       coalesce(order_attr.taxi_high_surge_flg, False) as taxi_high_surge_flg,
       --
       sum(gross_commission_revenue) as gross_commission_revenue,
       sum(incentives) as incentives,
       sum(b2b_revenue) as b2b_revenue,
       sum(b2b_expenses) as b2b_expenses
from tlog
  left join snb_b2b.niksm_temp_1002_order_attr order_attr
    on order_attr.order_id = tlog.order_id
group by 1,2,3,4,5,6,7,8,9,10,11;



with serv(service_id,service_owner) as (
    values (1161, 'Delivery'),
           (1162, 'Delivery'),
           (1163, 'Delivery'),
           (1164, 'Delivery'),
           (719, 'Delivery'),
           (718, 'Delivery'),
           (1168, 'Delivery'),
           (111, 'Taxi'),
           (124, 'Taxi'),
           (125, 'Taxi'),
           (128, 'Taxi'),
           (137, 'Taxi'),
           (651, 'Taxi'),
           (650, 'Taxi'),
           (697, 'Taxi')
)
, niksm_temp_1002_tlog as (
    select order_id,
           currency_code,
           service_owner,
           max(max(case when b2b_expenses<>0 then tariff_class end))
               over (partition by order_id) as order_tariff_class,
           utc_transaction_dttm,
           sum(transaction_value * gross_commission_revenue) as gross_commission_revenue,
           sum(transaction_value * incentives) as incentives,
           sum(transaction_value * b2b_revenue) as b2b_revenue,
           sum(transaction_value * b2b_expenses) as b2b_expenses,
           -- в т.ч. записи по order_id могут быть на другую дату транзакции; обрезать по датам после расчёта флагов
           bool_or(sum(transaction_value * b2b_revenue)<>0 and service_owner = 'Delivery')
               over (partition by order_id) as delivery_client_service_flg,
           bool_or(sum(transaction_value * b2b_expenses)<>0 and service_owner = 'Delivery')
               over (partition by order_id) as delivery_park_service_flg
    from snb_b2b.niksm_temp_1002_tlog_detailed as tlog
      join snb_b2b.niksm_finance_tlog_metrics as metr
        on metr.source = tlog.source
        and metr.detailed_product = tlog.detailed_product
      left join serv
        on serv.service_id = tlog.service_id
    group by order_id,
             currency_code,
             service_owner,
             utc_transaction_dttm
)
, tlog as (
    select order_id,
           utc_transaction_dttm at time zone 'UTC' at time zone 'Europe/Moscow' as msk_transaction_dttm,
           currency_code,
           service_owner,
           order_tariff_class,
           gross_commission_revenue,
           incentives,
           b2b_revenue,
           b2b_expenses,
           delivery_client_service_flg,
           delivery_park_service_flg
    from niksm_temp_1002_tlog
    where utc_transaction_dttm >= timestamp'2022-01-01' at time zone 'Europe/Moscow' at time zone 'UTC'
      and utc_transaction_dttm <  timestamp'2022-03-01' at time zone 'Europe/Moscow' at time zone 'UTC'
)
, blnc_dlv as (
    select distinct person_inn, person_kpp
    from snb_b2b.niksm_b2b_balance_contract_ext_info
      join snb_b2b.niksm_b2b_contracts_info
        on contract_external_id = contract_id
    where which_crm = 6
)
select order_tariff_class,
       blnc_dlv.person_inn is not null as dlv_inn_flg,
       sum(gross_commission_revenue) as gross_commission_revenue,
       sum(incentives) as incentives,
       sum(b2b_revenue) as b2b_revenue,
       sum(b2b_expenses) as b2b_expenses
from tlog
  join snb_b2b.niksm_temp_1002_order_attr order_attr
    on order_attr.order_id = tlog.order_id
  join taxi_cdm_marketplace.fct_order
    on fct_order.order_id = tlog.order_id
    and utc_order_created_dttm >= '2021-12-01'
  join snb_b2b.niksm_b2b_balance_contract_ext_info blnc
    on blnc.contract_external_id = fct_order.corp_contract_id
  left join blnc_dlv
    on blnc_dlv.person_inn = blnc.person_inn
    and blnc_dlv.person_kpp = blnc.person_kpp
where true
  and tlog.currency_code = 'RUB'
  and order_attr.corp_order_flg
  and not delivery_crm_flg
  and not delivery_client_service_flg
  and
group by 1,2;

with blnc_dlv as (
    select distinct person_inn, person_kpp
    from snb_b2b.niksm_b2b_balance_contract_ext_info
      join snb_b2b.niksm_b2b_contracts_info
        on contract_external_id = contract_id
    where which_crm = 6
)
select contract_external_id, client,
       blnc.person_inn, blnc.person_kpp, service_ids, blnc_dlv.person_inn
from snb_b2b.niksm_b2b_balance_contract_ext_info blnc
  left join blnc_dlv
    on blnc_dlv.person_inn = blnc.person_inn
    and blnc_dlv.person_kpp = blnc.person_kpp
where contract_external_id in ('254330/19','1198692/20');

select *
from snb_b2b.niksm_temp_1002_tlog_detailed
where order_id = '66428b4e8ce4d72f9b99e1aec44bd24c'
   or cargo_claim_id = '047c934964ce49d68001d6a265f9e3a3';

select order_id,
       count(distinct service_id),
       string_agg(service_id::text,','),
       sum(transaction_value) as transaction_value
from (
    select order_id, service_id,
           sum(case when transaction_type = 'payment' then transaction_value else -transaction_value end) as transaction_value
    from core_ods_billing.expenses tlog
      join snb_delivery.logdata_delivery_tariff
        on tariff_class = order_tariff
      join snb_b2b.niksm_finance_tlog_metrics as metr
        on metr.source = 'expenses'
        and metr.detailed_product = tlog.detailed_product
        and b2b_expenses<>0
    where utc_transaction_dttm >= '2021-11-01'
      and order_id is not null
    group by order_id, service_id
    having sum(case when transaction_type = 'payment' then transaction_value else -transaction_value end)<>0) q
group by order_id
having count(distinct service_id)>1;

select order_id,
       count(distinct service_id),
       string_agg(service_id::text,','),
       sum(transaction_value) as transaction_value
from (
    select coalesce(tlog.order_id,claim.taxi_order_id) as order_id,
           service_id,
           sum(transaction_value * aggregation_sign_code) as transaction_value
    from core_ods_billing.revenue tlog
      join snb_delivery.logdata_delivery_tariff
        on tariff_class = order_tariff
      join snb_b2b.niksm_finance_tlog_metrics as metr
        on metr.source = 'revenue'
        and metr.detailed_product = tlog.detailed_product
        and b2b_revenue<>0
      left join delivery_ods_cargo_claims.claim
        on claim.cargo_ref_id = tlog.cargo_claim_id
        and claim.utc_created_dttm >= '2021-09-01'
    where utc_transaction_dttm >= '2021-11-01'
      and order_id is not null
    group by coalesce(tlog.order_id,claim.taxi_order_id), service_id
    having sum(transaction_value * aggregation_sign_code)<>0
    ) q
group by order_id
having count(distinct service_id)>1;



select tlog.*
from core_ods_billing.expenses tlog
  join snb_delivery.logdata_delivery_tariff
    on tariff_class = order_tariff
where utc_transaction_dttm >= '2022-01-01'
  and order_id = 'bde0a82b05f6220e941cef861b853205'